/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.ChartaClient;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.network.CardTableSelectGamePayload;
import dev.lucaargolo.charta.network.PlayerOptionsPayload;
import dev.lucaargolo.charta.utils.CustomOptionTooltip;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class OptionsScreen<G extends CardGame<G>>
extends class_437 {
    private final class_437 parent;
    private final class_2338 pos;
    private final G game;
    private final class_2960 gameId;
    private final CardGames.Factory<G> gameFactory;
    private final boolean showcase;
    private OptionsWidget widget;
    private class_4185 resetButton;
    private class_4185 saveButton;

    public OptionsScreen(class_437 parent, class_2338 pos, G game, class_2960 gameId, CardGames.Factory<G> gameFactory, boolean showcase) {
        super((class_2561)class_2561.method_43469((String)"message.charta.this_game_options", (Object[])new Object[]{class_2561.method_43471((String)gameId.method_42094())}));
        this.parent = parent;
        this.pos = pos;
        this.game = game;
        this.gameId = gameId;
        this.gameFactory = gameFactory;
        this.showcase = showcase;
        if (!showcase) {
            Optional.ofNullable(ChartaClient.LOCAL_OPTIONS.get(this.gameId)).ifPresent(arg_0 -> game.setRawOptions(arg_0));
        }
    }

    protected void method_25426() {
        this.widget = (OptionsWidget)this.method_37063((class_364)new OptionsWidget(this.field_22787, this.field_22789, this.field_22790 - 60, 30));
        for (int i = 0; i < ((CardGame)this.game).getOptions().size(); ++i) {
            GameOption<?> option = ((CardGame)this.game).getOptions().get(i);
            this.widget.addEntry(option.getWidget(o -> this.updateButtons(false), this.field_22793, this.widget.method_25322(), 20, this.showcase));
        }
        class_5250 back = class_2561.method_43470((String)"\ue5c4").method_27696(Charta.SYMBOLS);
        this.method_37063((class_364)class_4185.method_46430((class_2561)back, b -> this.method_25419()).method_46434(5, 5, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.go_back"))).method_46431());
        if (!this.showcase) {
            this.resetButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.charta.reset"), b -> {
                boolean reset = CardGames.areOptionsChanged(this.gameFactory, this.game);
                if (reset) {
                    G defaultGame = this.gameFactory.create(List.of(), CardDeck.EMPTY);
                    ((CardGame)this.game).setRawOptions(((CardGame)defaultGame).getRawOptions());
                }
                this.updateButtons(false);
            }).method_46434(this.field_22789 / 2 - 108, this.field_22790 - 25, 68, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.reset_options"))).method_46431());
            this.resetButton.field_22763 = CardGames.areOptionsChanged(this.gameFactory, this.game);
            this.saveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.charta.save"), b -> {
                this.updateButtons(true);
                ChartaClient.LOCAL_OPTIONS.put(this.gameId, ((CardGame)this.game).getRawOptions());
                ClientPlayNetworking.send((class_8710)new PlayerOptionsPayload(ChartaClient.LOCAL_OPTIONS));
            }).method_46434(this.field_22789 / 2 - 32, this.field_22790 - 25, 68, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.save_options"))).method_46431());
            this.saveButton.field_22763 = false;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"button.charta.start"), b -> {
                ClientPlayNetworking.send((class_8710)new CardTableSelectGamePayload(this.pos, this.gameId, ((CardGame)this.game).getRawOptions()));
                this.method_25419();
            }).method_46434(this.field_22789 / 2 + 44, this.field_22790 - 25, 68, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.start_options"))).method_46431());
        }
        this.updateButtons(true);
    }

    public void updateButtons(boolean saved) {
        boolean reset = false;
        G defaultGame = this.gameFactory.create(List.of(), CardDeck.EMPTY);
        for (int i = 0; i < ((CardGame)defaultGame).getOptions().size(); ++i) {
            GameOption<?> defaultOption = ((CardGame)defaultGame).getOptions().get(i);
            GameOption<?> modifiedOption = ((CardGame)this.game).getOptions().get(i);
            GameOption.Widget entry = this.widget.getEntry(i);
            entry.setTooltip(new CustomOptionTooltip(entry.getTooltip(), defaultOption.get().toString(), modifiedOption.get().toString()));
            if (modifiedOption.getValue() != defaultOption.getValue()) {
                this.widget.changed.set(i, true);
                reset = true;
                continue;
            }
            this.widget.changed.set(i, false);
        }
        if (this.resetButton != null) {
            this.resetButton.field_22763 = reset;
        }
        if (this.saveButton != null) {
            this.saveButton.field_22763 = !saved;
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, -1);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public static class OptionsWidget
    extends class_4265<GameOption.Widget> {
        protected final BooleanList changed = new BooleanArrayList();

        public OptionsWidget(class_310 minecraft, int width, int height, int y) {
            super(minecraft, width, height, y, 25);
        }

        protected void method_44397(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
            super.method_44397(guiGraphics, mouseX, mouseY, partialTick, index, left, top, width, height);
            if (this.changed.getBoolean(index)) {
                guiGraphics.method_25303(this.field_22740.field_1772, "!", left + width - 4, top + 2, class_156.method_658() / 1000L % 2L == 0L ? 0xFF0000 : 0xFFFF00);
            }
        }

        public int addEntry(@NotNull GameOption.Widget entry) {
            this.changed.add(false);
            return super.method_25321((class_350.class_351)entry);
        }

        public @NotNull GameOption.Widget getEntry(int index) {
            return (GameOption.Widget)super.method_25326(index);
        }
    }
}

